<?php
session_start();
header('Content-Type: application/json');
include "conn.php";

$invoice_no = $_GET['invoice_no'] ?? '';
$response = ['success' => false];

if ($invoice_no) {
    $stmt = $con->prepare("SELECT transfer_date, transfer_time, grand_total, payment_method 
                           FROM invoice 
                           WHERE invoice_no = ?");
    $stmt->bind_param("s", $invoice_no);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $response = [
            'success' => true,
            'transfer_date' => $row['transfer_date'] ?? '',
            'transfer_time' => $row['transfer_time'] ?? '',
            'amount_pay'    => number_format($row['grand_total'], 2),
            'payment_method'=> $row['payment_method']
        ];
    } else {
        $response['message'] = "Invoice not found";
    }
}

echo json_encode($response);