<?php
session_start();
include "conn.php";

// Admin / Shipping / Cashier can see all
if (in_array($_SESSION['role'], ['shipping', 'admin', 'cashier'])) {

    $sql = "SELECT COUNT(*) as total 
            FROM invoice 
            WHERE shipping_status NOT IN ('Shipped', 'Counter')";
    $stmt = $con->prepare($sql);

} else {

    $sql = "SELECT COUNT(*) as total 
            FROM invoice 
            WHERE shipping_status NOT IN ('Shipped', 'Counter')
              AND customer_id = ?";
    $stmt = $con->prepare($sql);
    $stmt->bind_param("i", $_SESSION['aidi']);

}

$stmt->execute();
$res = $stmt->get_result()->fetch_assoc();
echo json_encode(['count' => $res['total'] ?? 0]);

