<?php
session_start();
$key = md5(date("Y-m-d").":".$_SERVER['REMOTE_ADDR']);
if (isset($_SESSION['aW1iZXN0cmEuY29tLm15']) <> $key) {
    header("location:".$_SERVER['REQUEST_SCHEME']."://".$_SERVER['SERVER_NAME']);
} else {

    include "_header.php";
    include "_navtop.php";
    include "_navside.php";
    include "_functions.php";
    require "conn.php";

    // ---------------------- HANDLE PACKAGE CRUD ------------------------
    if (isset($_POST['add_package'])) {
        $name   = mysqli_real_escape_string($con, $_POST['name']);
        $price  = mysqli_real_escape_string($con, $_POST['price']);
        $qty    = mysqli_real_escape_string($con, $_POST['qty_set']);
        $direct = mysqli_real_escape_string($con, $_POST['direct_sponsor']);
        $level  = mysqli_real_escape_string($con, $_POST['commission_level']);

        mysqli_query($con, "INSERT INTO packages (name, price, qty_set, direct_sponsor, commission_level) 
                            VALUES ('$name','$price','$qty','$direct','$level')");
        $pkg_msg = '<div class="alert alert-success">Package added successfully!</div>';
    }

    if (isset($_POST['update_package'])) {
        $id     = intval($_POST['update_package']); // from button value
        $name   = mysqli_real_escape_string($con, $_POST['name']);
        $price  = mysqli_real_escape_string($con, $_POST['price']);
        $qty    = mysqli_real_escape_string($con, $_POST['qty_set']);
        $direct = mysqli_real_escape_string($con, $_POST['direct_sponsor']);
        $level  = mysqli_real_escape_string($con, $_POST['commission_level']);

        mysqli_query($con, "UPDATE packages SET 
                name='$name', price='$price', qty_set='$qty', 
                direct_sponsor='$direct', commission_level='$level' 
                WHERE id=$id");
        $pkg_msg = '<div class="alert alert-info">Package updated successfully!</div>';
    }

    if (isset($_GET['delete_pkg'])) {
        $id = intval($_GET['delete_pkg']);
        mysqli_query($con, "DELETE FROM packages WHERE id=$id");
        $pkg_msg = '<div class="alert alert-danger">Package deleted successfully!</div>';
    }
    // -------------------------------------------------------------------

    // ---------------------- HANDLE COMMISSION + SPONSOR LIMIT ----------
    if (isset($_POST['komisen'])) {
        $k1  = mysqli_real_escape_string($con, $_POST['k1']);
        $k2  = mysqli_real_escape_string($con, $_POST['k2']);
        $k3  = mysqli_real_escape_string($con, $_POST['k3']);
        $k4  = mysqli_real_escape_string($con, $_POST['k4']);
        $k5  = mysqli_real_escape_string($con, $_POST['k5']);
        $k6  = mysqli_real_escape_string($con, $_POST['k6']);
        $k7  = mysqli_real_escape_string($con, $_POST['k7']);
        $k8  = mysqli_real_escape_string($con, $_POST['k8']);
        $k9  = mysqli_real_escape_string($con, $_POST['k9']);
        $k10 = mysqli_real_escape_string($con, $_POST['k10']);
        $mp  = mysqli_real_escape_string($con, $_POST['mp']);
        $pv  = mysqli_real_escape_string($con, $_POST['pv']);

        mysqli_query($con, "UPDATE komisen SET lvl1='$k1', lvl2='$k2', lvl3='$k3', lvl4='$k4', lvl5='$k5',
            lvl6='$k6', lvl7='$k7', lvl8='$k8', lvl9='$k9', lvl10='$k10', maksima='$mp', nilaipin='$pv'");

        $sl = mysqli_real_escape_string($con, $_POST['sl']);
        $ll = mysqli_real_escape_string($con, $_POST['ll']);
        $ma = mysqli_real_escape_string($con, $_POST['ma']);
        $tx = mysqli_real_escape_string($con, $_POST['tx']);
        mysqli_query($con, "UPDATE setting SET sponsor_limit='$sl' , level_limit='$ll' , multiple_acc='$ma' , tax='$tx'");

        $upd = true;
    }

    // ---------------------- HANDLE DISCOUNT CRUD ------------------------
    if (isset($_POST['add_discount'])) {
        $name  = mysqli_real_escape_string($con, $_POST['name']);
        $qty   = (int) $_POST['qty'];
        $value = mysqli_real_escape_string($con, $_POST['value']);
    
        mysqli_query($con, "INSERT INTO discount (name, qty, value) 
                            VALUES ('$name','$qty','$value')");
        $disc_msg = '<div class="alert alert-success">Discount added successfully!</div>';
    }
    
    if (isset($_POST['update_discount'])) {
        $id    = intval($_POST['update_discount']); // button value
        $name  = mysqli_real_escape_string($con, $_POST['name']);
        $qty   = (int) $_POST['qty'];
        $value = mysqli_real_escape_string($con, $_POST['value']);
    
        mysqli_query($con, "UPDATE discount SET 
                name='$name', qty='$qty', value='$value' 
                WHERE id=$id");
        $disc_msg = '<div class="alert alert-info">Discount updated successfully!</div>';
    }
    
    if (isset($_POST['delete_discount'])) {
        $id = intval($_POST['delete_discount']);
        mysqli_query($con, "DELETE FROM discount WHERE id=$id");
        $disc_msg = '<div class="alert alert-danger">Discount deleted successfully!</div>';
    }
    // --------------------------------------------------------------------

    
    // Pastikan sebelum form
    if (!isset($currentState)) {
        $currentState = ''; // default empty
    }

    // --- PRELOAD PACKAGE LIST ---
    $package_list = [];
    $pkgQuery = $con->query("SELECT name FROM packages ORDER BY name ASC");
    while ($p = $pkgQuery->fetch_assoc()) {
        $package_list[] = $p['name'];
    }
    
    // --- PRELOAD MALAYSIA STATES ---
    $states = [
      "Johor", "Kedah", "Kelantan", "Melaka", "Negeri Sembilan",
      "Pahang", "Perak", "Perlis", "Pulau Pinang", "Sabah", "Sarawak",
      "Selangor", "Terengganu", "Kuala Lumpur", "Putrajaya", "Labuan", "Semenanjung Malaysia"
    ];


    // ---------------------- HANDLE SHIPPING CRUD ------------------------
    // Add Shipping
    if (isset($_POST['add_shipping'])) {
        
    $region_type = $_POST['region_type'] ?? 'all';
    
        if($region_type == 'all'){
            $name = "Semenanjung Malaysia";
        }else{
            $name = mysqli_real_escape_string($con, $_POST['name']);
        }
    
        $package = $_POST['package'] ?? '';
        //    = $_POST['name'] ?? '';
        $qty     = (int) ($_POST['qty'] ?? 0);
        $value   = (float) ($_POST['value'] ?? 0);
    
        if ($package && $name && $qty >= 0 && $value >= 0) {
            $stmt = $con->prepare("INSERT INTO shipping_cost (package, name, qty, value) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssid", $package, $name, $qty, $value);
            $stmt->execute();
            $stmt->close();
            $ship_msg = '<div class="alert alert-success">Shipping cost added successfully!</div>';
        } else {
            $ship_msg = '<div class="alert alert-danger">Invalid input!</div>';
        }
    }
    
    // Update Shipping
    if (isset($_POST['update_shipping'])) {
        $id      = intval($_POST['update_shipping']); // button value
        $package = $_POST['package'] ?? '';
        $name    = $_POST['name'] ?? '';
        $qty     = (int) ($_POST['qty'] ?? 0);
        $value   = (float) ($_POST['value'] ?? 0);
    
        if ($id && $package && $name && $qty >= 0 && $value >= 0) {
            $stmt = $con->prepare("UPDATE shipping_cost SET package=?, name=?, qty=?, value=? WHERE id=?");
            $stmt->bind_param("ssidi", $package, $name, $qty, $value, $id);
            $stmt->execute();
            $stmt->close();
            $ship_msg = '<div class="alert alert-info">Shipping cost updated successfully!</div>';
        } else {
            $ship_msg = '<div class="alert alert-danger">Invalid input!</div>';
        }
    }
    
    // Delete Shipping (POST)
    if (isset($_POST['delete_shipping'])) {
        $id = intval($_POST['delete_shipping']);
        if ($id > 0) {
            $stmt = $con->prepare("DELETE FROM shipping_cost WHERE id=?");
            $stmt->bind_param("i", $id);
            $stmt->execute();
            $stmt->close();
            $ship_msg = '<div class="alert alert-danger">Shipping cost deleted successfully!</div>';
        }
    }

    // --------------------------------------------------------------------


    $kms = mysqli_fetch_array(mysqli_query($con, "SELECT * FROM komisen"));
    $spl = mysqli_fetch_array(mysqli_query($con, "SELECT * FROM setting"));
?>
<div id="page-wrapper">
  <div id="page-inner">
    <div class="row">
      <div class="col-md-12">
        <h2><i class="fa fa-cogs"></i> Setting</h2>
      </div>
    </div>

    <?php if (!empty($upd)) { ?>
      <div class="alert alert-info">Commission settings saved.</div>
      <script>
        setTimeout(() => { $(".alert").fadeTo(500,0).slideUp(500,()=>$(this).remove()); },2000);
      </script>
    <?php } ?>

    <?php if (!empty($pkg_msg)) : ?>
    <?= $pkg_msg ?>
        <script>
            setTimeout(function() {
                $(".alert").fadeTo(500, 0).slideUp(500, function() {
                    $(this).remove();
                });
            }, 2000);
        </script>
    <?php endif; ?>
    <?php if (!empty($ship_msg)) : ?>
    <?= $ship_msg ?>
        <script>
            setTimeout(function() {
                $(".alert").fadeTo(500, 0).slideUp(500, function() {
                    $(this).remove();
                });
            }, 2000);
        </script>
    <?php endif; ?>


    <hr/>

    <div class="row">
      <div class="col-md-12">
        <!-- Commission & Sponsor Limit -->
        <div class="panel panel-default">
          <div class="panel-heading">General Setting</div>
          <div class="panel-body">
            <form method="post">
              <div class="row">
                <!-- Commission Inputs -->
                <div class="col-md-4" style="background:#FAFAFA;padding:20px;margin:10px;border:2px solid #EEE;">
                  <h4 class="text-center"><i class="fa fa-sitemap fa-2x text-primary"></i></h4><center>Commission Level</center>
                  <hr>
                  <?php for($i=1;$i<=9;$i++){ ?>
                    <div class="form-group">
                      <label>Level <?= $i ?> <small>(RM)</small></label>
                      <input class="form-control" name="k<?= $i ?>" value="<?= $kms[$i] ?>" step=".01" type="number" placeholder="Level <?= $i ?>" />
                    </div>
                  <?php } ?>
                  <input type="hidden" name="k10" value="<?= $kms[10] ?>">
                  <div class="form-group">
                    <label>Maximum Payout</label>
                    <input class="form-control" name="mp" value="<?= $kms['maksima'] ?>" type="text" />
                  </div>
                </div>

                <!-- Sponsor Limit -->
                <div class="col-md-3" style="background:#FAFAFA;padding:20px;margin:10px;border:2px solid #EEE;">
                  <h4 class="text-center"><i class="fa fa-gauge fa-2x text-primary"></i></h4><center>Limit</center>
                  <hr>
                  <div class="form-group">
                    <label>Sponsor Limit</label>
                    <input class="form-control" name="sl" value="<?= $spl['sponsor_limit'] ?>" type="number" />
                  </div>
                  <div class="form-group">
                    <label>Level Limit</label>
                    <input class="form-control" name="ll" value="<?= $spl['level_limit'] ?>" type="number" />
                  </div>
                  <div class="form-group">
                    <label>Multiple Account Limit</label>
                    <input class="form-control" name="ma" value="<?= $spl['multiple_acc'] ?>" type="number" />
                  </div>
                  <div class="form-group">
                    <label>TAX ( SST % )</label>
                    <input class="form-control" name="tx" value="<?= $spl['tax'] ?>" type="number" />
                  </div>
                </div>
                
                <!-- Basic Package -->
                <div class="col-md-3" style="background:#FAFAFA;padding:20px;margin:10px;border:2px solid #EEE;">
                  <h4 class="text-center"><i class="fa fa-key fa-2x text-primary"></i></h4><center>PIN</center>
                  <hr>
                  <div class="form-group">
                    <label>PIN Value <small>(RM)</small></label>
                    <input class="form-control" name="pv" value="<?= $kms['nilaipin'] ?>" type="number" />
                  </div>
                </div> 
                
                <!-- Discount -->
                <div class="col-md-6" style="background:#FAFAFA;border:2px solid #EEE; margin:10px;">
                  <h4 class="text-center"><i class="fa fa-percent fa-2x text-primary"></i></h4><center>Discount</center>
                  <hr>
                      <?php if (isset($disc_msg)) echo $disc_msg; ?>
                       <!-- Add Discount -->
                        <form method="post" class="mb-3">
                          <div class="row g-2">
                            <div class="col-md-4">
                              <select name="name" class="form-control">
                                <option value="">-- Select Category --</option>
                                <option value="Product">Product</option>
                                <option value="Stock">Stock</option>
                              </select>
                            </div>
                            <div class="col-md-3">
                              <input type="number" name="qty" class="form-control" placeholder="Qty" >
                            </div>
                            <div class="col-md-3">
                              <input type="number" step="0.01" name="value" class="form-control" placeholder="Discount (RM)" >
                            </div>
                            <div class="col-md-2">
                              <button type="submit" name="add_discount" class="btn btn-success w-100">
                                <i class="fa fa-plus"></i> Add
                              </button>
                            </div>
                          </div>
                        </form>
                        <br>
                        <!-- Discount List -->
                        <div class="table-responsive">
                          <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                              <tr>
                                <th>No</th>
                                <th>Category</th>
                                <th>Qty</th>
                                <th>Discount (RM)</th>
                                <th width="150">Action</th>
                              </tr>
                            </thead>
                            <tbody>
                            <?php
                            $result = mysqli_query($con, "SELECT * FROM discount ORDER BY id ASC");
                            while ($row = mysqli_fetch_assoc($result)) { ?>
                              <tr>
                                <form method="post">
                                  <td><?= $row['id'] ?><input type="hidden" name="id" value="<?= $row['id'] ?>"></td>
                                  <td><input type="text" name="name" value="<?= $row['name'] ?>" class="form-control"></td>
                                  <td><input type="number" name="qty" value="<?= $row['qty'] ?>" class="form-control"></td>
                                  <td><input type="number" step="0.01" name="value" value="<?= $row['value'] ?>" class="form-control"></td>
                                  <td>
                                      <center>
                                        <!-- UPDATE -->
                                        <button type="submit" name="update_discount" value="<?= $row['id'] ?>" 
                                                class="btn btn-transparent" style="background:transparent;border:none;padding:0;">
                                          <i class="fa fa-save fa-2x text-success"></i>
                                        </button>
                                    
                                        <!-- DELETE -->
                                        <button type="submit" name="delete_discount" value="<?= $row['id'] ?>"
                                                onclick="return confirm('Delete this discount ?')" 
                                                class="btn btn-transparent" style="background:transparent;border:none;padding:0;">
                                          <i class="fa fa-trash fa-2x text-danger"></i>
                                        </button>
                                      </center>
                                    </td>
                                </form>
                              </tr>
                            <?php } ?>
                            </tbody>
                          </table>
                        </div>
                </div>

                <!-- Shipping Cost -->
                <div class="col-md-12" style="background:#FAFAFA;border:2px solid #EEE; margin:10px;">
                  <h4 class="text-center"><i class="fa fa-truck fa-2x text-primary"></i></h4><center>Shipping Cost</center>
                  <hr>
                      <?php if (isset($ship_msg)) echo $ship_msg; ?>
 
                       <!-- Add Shipping -->
                        <form method="post" class="mb-3">
                          <div class="row g-2">
                                                        <!-- REGION / CATEGORY = NEGERI MALAYSIA -->
                            <div class="col-md-6 mb-2" style="padding-top:20px">
                                <div class="d-flex align-items-center gap-4 flex-wrap">
                            
                                    
                            <div>Custom / Flat Rate</div>
                                    <!-- Radio: Specific State -->
                                    <div class="form-check d-flex align-items-center gap-2 mb-0" style="display:inline-block; padding-top:8px;">
                                        <input class="form-check-input" type="radio" name="region_type" value="specific" id="specificState"
                                            <?= ($currentState!='Semenanjung Malaysia') ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="specificState">
                                            Specific State
                                        </label>
                                    </div>
                                    <!-- Radio: Semenanjung Malaysia -->
                                    <div class="form-check d-flex align-items-center gap-2 mb-0" style="display:inline-block; padding-left:20px;">
                                        <input class="form-check-input" type="radio" name="region_type" value="all" id="allPeninsula"
                                            <?= ($currentState=='Semenanjung Malaysia') ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="allPeninsula">
                                            Semenanjung Malaysia
                                        </label>
                                    </div>
                                    <!-- State Dropdown -->
                                    <div style="min-width:220px;">
                                        <select name="name" id="stateDropdown" class="form-control">
                                            <option value="">-- Select State --</option>
                                            <?php
                                            $statess = [
                                                "Johor", "Kedah", "Kelantan", "Melaka", "Negeri Sembilan",
                                                "Pahang", "Perak", "Perlis", "Pulau Pinang", "Sabah", "Sarawak",
                                                "Selangor", "Terengganu", "Kuala Lumpur", "Putrajaya", "Labuan"
                                            ];
                                            foreach($statess as $s){
                                                $sel = ($currentState==$s) ? 'selected' : '';
                                                echo "<option value='$s' $sel>$s</option>";
                                            }
                                            ?>
                                        </select>
                                    </div>
                            
                                </div>
                            </div>
<br/>
                            <div class="col-md-6">
                              <select name="package" class="form-control" required>
                                <option value="">-- Select Package --</option>
                                <?php
                                $packages = mysqli_query($con, "SELECT name FROM packages ORDER BY name ASC");
                                while ($pkg = mysqli_fetch_assoc($packages)) {
                                    echo '<option value="'.htmlspecialchars($pkg['name']).'">'.htmlspecialchars($pkg['name']).'</option>';
                                }
                                ?>
                              </select>
                            </div>
<script>
const radioAll = document.querySelector('input[value="all"]');
const radioSpecific = document.querySelector('input[value="specific"]');
const dropdown = document.getElementById('stateDropdown');

function toggleDropdown() {
    dropdown.disabled = radioAll.checked;
}
radioAll.addEventListener('change', toggleDropdown);
radioSpecific.addEventListener('change', toggleDropdown);
toggleDropdown(); // initialize
</script>

                            <div class="col-md-2" style="padding-top:20px">
                              <input type="number" name="qty" class="form-control" placeholder="Qty/Weight" required>
                            </div>
                            <br/>
                            <div class="col-md-2" style="padding-top:20px">
                              <input type="number" step="0.01" name="value" class="form-control" placeholder="Shipping (RM)" required>
                            </div>
                            <div class="col-md-2" style="padding-top:20px">
                              <button type="submit" name="add_shipping" class="btn btn-success w-100">
                                <i class="fa fa-plus"></i> Add
                              </button>
                            </div>
                          </div>
                        </form>
                        <hr>

                        <!-- Shipping List -->
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover align-middle">
                            <thead class="table-light">
                              <tr>
                                <th>No</th>
                                <th>Package</th>
                                <th>Region/Category</th>
                                <th>Qty/Weight</th>
                                <th>Shipping (RM)</th>
                                <th width="150">Action</th>
                              </tr>
                            </thead>
                            
                            <tbody>
                            <?php
                            $result = $con->query("SELECT * FROM shipping_cost ORDER BY id ASC");
                            while ($row = $result->fetch_assoc()) {
                            
                                $currentPkg = trim($row['package']);
                                $currentState = trim($row['name']);
                            ?>
                            <tr>
                              <form method="post">
                                <td>
                                    <?= $row['id'] ?>
                                    <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                </td>
                            
                                <!-- PACKAGE DROPDOWN -->
                                <td>
                                  <select name="package" class="form-control">
                                    <option value="" <?= ($currentPkg == '' ? 'selected' : '') ?>>-- None --</option>
                                    <?php foreach ($package_list as $pkgName): 
                                      $selected = ($pkgName == $currentPkg) ? 'selected' : '';
                                    ?>
                                      <option value="<?= htmlspecialchars($pkgName) ?>" <?= $selected ?>>
                                        <?= htmlspecialchars($pkgName) ?>
                                      </option>
                                    <?php endforeach; ?>
                                  </select>
                                </td>
                            
                                <!-- REGION / STATE DROPDOWN -->
                                <td>
                                  <select name="name" class="form-control">
                                    <option value="" <?= (empty($currentState)) ?> selected> -- None --</option>
                                    <?php foreach ($states as $state): 
                                      $sel = ($state == $currentState) ? 'selected' : '';
                                    ?>
                                      <option value="<?= $state ?>" <?= $sel ?>><?= $state ?></option>
                                    <?php endforeach; ?>
                                  </select>
                                </td>
                            
                                <td>
                                  <input type="number" name="qty" value="<?= $row['qty'] ?>" 
                                         class="form-control" min="0">
                                </td>
                            
                                <td>
                                  <input type="number" step="0.01" name="value" 
                                         value="<?= $row['value'] ?>" class="form-control" min="0">
                                </td>
                            
                                <td>
                                      <center>
                                        <!-- UPDATE -->
                                        <button type="submit" name="update_shipping" value="<?= $row['id'] ?>" 
                                                class="btn btn-transparent" style="background:transparent;border:none;padding:0;">
                                          <i class="fa fa-save fa-2x text-success"></i>
                                        </button>
                                    
                                        <!-- DELETE -->
                                        <button type="submit" name="delete_shipping" value="<?= $row['id'] ?>"
                                                onclick="return confirm('Delete this shipping cost?')" 
                                                class="btn btn-transparent" style="background:transparent;border:none;padding:0;">
                                          <i class="fa fa-trash fa-2x text-danger"></i>
                                        </button>
                                      </center>
                                </td>
                              </form>
                            </tr>
                            <?php } ?>
                            </tbody>
                            </table>
                        </div>

                </div>


                <div class="col-md-12" style="margin:10px;">
                  <button type="submit" name="komisen" class="btn btn-primary">Save</button>
                </div>
              </div>
            </form>
          </div>
        </div>

        <!-- Packages -->
        <div class="panel panel-default">
          <div class="panel-heading">Packages</div>
          <div class="panel-body">
            <!-- Add Package -->
            <form method="post" class="mb-3">
              <div class="row g-2">
                <div class="col-md-2"><input type="text" name="name" class="form-control" placeholder="Name" required></div>
                <div class="col-md-2"><input type="number" step="0.01" name="price" class="form-control" placeholder="Price" required></div>
                <div class="col-md-2"><input type="number" name="qty_set" class="form-control" placeholder="Qty" required></div>
                <div class="col-md-2"><input type="number" step="0.01" name="direct_sponsor" class="form-control" placeholder="Sponsor RM" required></div>
                <div class="col-md-2"><input type="number" name="commission_level" class="form-control" placeholder="Commission Level" required></div>
                <div class="col-md-2">
                  <button type="submit" name="add_package" class="btn btn-success w-100">
                    <i class="fa fa-plus"></i> Add
                  </button>
                </div>
              </div>
            </form>
            <br>
            <!-- Package List -->
            <div class="table-responsive">
              <table class="table table-bordered table-hover align-middle">
                <thead class="table-light">
                  <tr>
                    <th>No</th>
                    <th>Name</th>
                    <th>Price (RM)</th>
                    <th>Qty</th>
                    <th>Sponsor RM</th>
                    <th>Commission Level</th>
                    <th width="150">Action</th>
                  </tr>
                </thead>
                <tbody>
                <?php
                $result = mysqli_query($con, "SELECT * FROM packages ORDER BY id ASC");
                while ($row = mysqli_fetch_assoc($result)) { ?>
                  <tr>
                    <form method="post">
                      <td><?= $row['id'] ?><input type="hidden" name="id" value="<?= $row['id'] ?>"></td>
                      <td><input type="text" name="name" value="<?= $row['name'] ?>" class="form-control"></td>
                      <td><input type="number" step="0.01" name="price" value="<?= $row['price'] ?>" class="form-control"></td>
                      <td><input type="number" name="qty_set" value="<?= $row['qty_set'] ?>" class="form-control"></td>
                      <td><input type="number" step="0.01" name="direct_sponsor" value="<?= $row['direct_sponsor'] ?>" class="form-control"></td>
                      <td><input type="number" name="commission_level" value="<?= $row['commission_level'] ?>" class="form-control"></td>
                      <td>
                          <center>
                            <button type="submit" name="update_package" value="<?= $row['id'] ?>" class="btn btn-transparent" style="background:transparent; border:none; color:#007bff; padding:0;">
                              <i class="fa fa-save fa-2x text-success"></i>
                            </button>
                            <button type="submit" name="edit_packageItem" value="<?= $row['id'] ?>" class="btn btn-transparent" style="background:transparent; border:none; color:#007bff; padding:0;">
                              <i class="fa fa-edit fa-2x text-primary"></i>
                            </button>
                            <a href="?delete_pkg=<?= $row['id'] ?>" onclick="return confirm('Delete this package?')" class="btn btn-transparent" style="background:transparent; border:none; color:#007bff; padding:0;">
                              <i class="fa fa-trash fa-2x text-danger"></i>
                            </a>
                        </center>
                      </td>
                    </form>
                  </tr>
                <?php } ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>




      </div>
    </div>
  </div>
</div>
<?php include "_footer.php"; } ?>
